# RIG

## Repo initialization

For convenience of version update and iteration, it is recommended to install the environment in the following way:

```bash
mkdir rigx_vlm && cd rigx_vlm
git clone https://gitlab.pjlab.org.cn/openmmlab/bigmodel/rigx.git -b dev
git clone https://github.com/pppppM/xtuner.git -b rigx
git clone https://github.com/hhaAndroid/Janus.git -b hha

# suggest soft link(if relative path link fails, you can use absolute path)
cd rigx
ln -s ../xtuner/xtuner .
ln -s ../Janus/janus .
```

If you find it troublesome, you can also install xtuner via `pip install -e .`

## Environment Installation

```shell
pip install -r RIG/requirements.txt
pip install attrdict
```

## Data Preparation
As the example of image-in-image-out, and stored in jsonl format

```shell
```json lines
{"id": 0, "conversations": [
            {
                "from": "human",
                "value": "<image>\nPlease generate the target image based the source image and editing instructions, and provide a description of the target image. Editing instructions: xxxx",
                "images": ["images/orig.png"],
            },
            {"from": "gpt", "value": "Target image description: yyyy. Target image: <image>",
                "images": ["images/target.png"]},
]}
```

Considering some customization needs, when preparing the meta file (refer to demo_data/janus_sft.json), you can set some additional parameters to speed up the startup
- default_num_tokens indicates the default number of tokens in the current dataset, which can avoid calculation before packing when set
- num_samples is only for user visualization and has no other purpose, it can be omitted


## Janus-1.3B Training

```shell
cd rigx/vlm_tools
bash shell/janus_dsw.sh
```

## Inference

If you want to test the inference, you can run the following command:
```shell
cd Janus
python image_to_image.py
```

